//Scripted by Jumpnjahosofat
//This file is part of the Urshaabi Gauntlet System
//I do not take complete credit for all of the files.  Many are modified RunUO scripts.
//This system is intended for drop in purposes so that it's easy for everyone to enjoy it.
//If you encounter problems, please leave me a message on the forum or my email - uo_cecil@yahoo.com
//Enjoy!!

using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "the corpse of Evilsoul" )]
	public class Evilsoul : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.MortalStrike : WeaponAbility.BleedAttack;
		}

		public override bool IgnoreYoungProtection { get { return Core.ML; } }

		[Constructable]
		public Evilsoul() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "Evilsoul";
			Title = "the Damned";
			Body = 79;
			BaseSoundID = 412;

			SetStr( 900 );
			SetDex( 45 );
			SetInt( 190 );

			SetHits( 1500 );

			SetDamage( 20, 26 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 90 );
			SetResistance( ResistanceType.Fire, 60 );
			SetResistance( ResistanceType.Cold, 75 );
			SetResistance( ResistanceType.Poison, 60 );
			SetResistance( ResistanceType.Energy, 100 );

			SetSkill( SkillName.DetectHidden, 80.0 );
			SetSkill( SkillName.Meditation, 120.0 );
			SetSkill( SkillName.Poisoning, 160.0 );
			SetSkill( SkillName.MagicResist, 100.0 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 80.0 );

			Fame = 24000;
			Karma = -24000;

			VirtualArmor = 55;
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 2 );
		}
		
		public override bool OnBeforeDeath()
		{
			StarRoomGate gate = new StarRoomGate( true );
			gate.Name = "Gauntlet of Horrors Level 3";
			gate.Target = new Point3D( 5306, 1175, 0 );
			gate.TargetMap = this.Map;
			gate.Hue = 34;
			gate.MoveToWorld( new Point3D( 5276, 1173, 0 ), this.Map );
			
			return base.OnBeforeDeath();
		}
		
		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			damage = 0;
			from.SendMessage( "{0} nelze zranit zbrani.", this.Name );
		}
		
		public override void OnDamagedBySpell( Mobile attacker )
		{
			base.OnDamagedBySpell( attacker );
			
			if ( Utility.RandomDouble() < 0.1 )
				Summon();
		}
		
		public void Summon()
		{
			Map map = this.Map;

			if ( map == null )
				return;

			int newSummon = Utility.RandomMinMax( 4, 6 );
			
			for ( int i = 0; i < newSummon; ++i )
			{
				Mobile summon = null;
				
				switch ( Utility.Random( 2 ) )
				{
					case 0: summon = new BlackLichWraith(); break;
					case 1: summon = new SumZombie(); break;
				}

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 3 ) - 1;
					int y = Y + Utility.Random( 3 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}
				
				summon.MoveToWorld( loc, map );
				summon.Combatant = null;
			}
		}
		
		public override bool AutoDispel{ get{ return true; } }
		public override bool BardImmune{ get{ return !Core.SE; } }
		public override bool Unprovokable{ get{ return Core.SE; } }
		public override bool Uncalmable{ get{ return Core.SE; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return (0.8 >= Utility.RandomDouble() ? Poison.Greater : Poison.Deadly); } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override int TreasureMapLevel{ get{ return 1; } }

		public Evilsoul( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( BaseSoundID == 1200 )
				BaseSoundID = 412;
		}
	}
}